/*****************************************
*	SD21 example code for ATMEGA32       *
*	Moves a servo between 2 positions    *
*										 *
*	By James Henderson, 2010			 *
*****************************************/

#include <inttypes.h>
#include <stdio.h>
#include <stdlib.h>
#include <avr/io.h>

#include "main.h"

int main(void)
{
	setup();
	
	unsigned int max_pos = 2000;			// Set max position
	unsigned int min_pos = 1000;			// Set min position
	unsigned char high_byte, low_byte;

	while(1)
	{	
		high_byte = min_pos >> 8;			// Get high byte of min_pos		
		low_byte = min_pos & 0xFF;			// Get low byte
		 
		i2c_transmit(SD21, 1, low_byte);	// send low byte of min.pos
		i2c_transmit(SD21, 2, high_byte);	// send High byte of min.pos
		
		startTimer(0xFFFF);					// Pause to let the servo move to its position
		waitForTimer();				

		high_byte = max_pos >> 8;			// Get high byte of max pos
		low_byte = max_pos & 0xFF;			// Get low byte

		i2c_transmit(SD21, 1, low_byte);	// send low byte of max_pos
		i2c_transmit(SD21, 2, high_byte);	// send High byte of max_pos

		startTimer(0xFFFF);					// Pause to let the servo move to its position
		waitForTimer();	
	}
}

void startTimer(unsigned int time)
{
	OCR1A = time;			// Time set to count to
	TIFR = 0x10;			// Clear timer campare match flag
	TCNT1 = 0x00; 			// Clear timer to zero
	TCCR1B = START_CLK;		// Start timer running 1:64 prescaler
}

void waitForTimer(void)
{
	while(!(TIFR&0x10));	// wait for timer to set compare match flag
	TCCR1B = STOP_CLK;		// Stop the timer
}

void setup(void)
{
	TCCR1A = 0x00;			// Set timer up in CTC mode
	TCCR1B = 0x08;	
	
	TWBR = 0x20;			// 100MHz I2C clock frequency	
}

