/*****************************************
*	SD20 example code for ATMEGA32       *
*	Moves a servo between 2 positions    *
*										 *
*	By James Henderson, 2010			 *
*****************************************/

#include <inttypes.h>
#include <stdio.h>
#include <stdlib.h>
#include <avr/io.h>

#include "main.h"

int main(void)
{
	setup();
	
	while(1)
	{	
		i2c_transmit(SD20, 1, MIN_SERVO);	// Set minimum servo position
		startTimer(0xFFFF);					// Pause to let the servo move to its position
		waitForTimer();				
		i2c_transmit(SD20, 1, MAX_SERVO);	// Set maximum servo position
		startTimer(0xFFFF);					// Pause to let the servo move to its position
		waitForTimer();	
	}
}

void startTimer(unsigned int time)
{
	OCR1A = time;			// Time set to count to
	TIFR = 0x10;			// Clear timer campare match flag
	TCNT1 = 0x00; 			// Clear timer to zero
	TCCR1B = START_CLK;		// Start timer running 1:64 prescaler
}

void waitForTimer(void)
{
	while(!(TIFR&0x10));	// wait for timer to set compare match flag
	TCCR1B = STOP_CLK;		// Stop the timer
}

void setup(void)
{
	TCCR1A = 0x00;			// Set timer up in CTC mode
	TCCR1B = 0x08;	
	
	TWBR = 0x20;			// 100MHz I2C clock frequency	
}

